<?php
require '../../includes/auth.php';
checkRole(['Doctor']);

$patient_id = $_GET['patient_id'] ?? null;
if (!$patient_id) die("Patient not selected");

// Fetch Patient Info
$stmt = $pdo->prepare("SELECT * FROM patients WHERE id = ?");
$stmt->execute([$patient_id]);
$p = $stmt->fetch();

// Handle Form Submission (Save Visit + Prescription + Labs)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $pdo->beginTransaction();

        // 1. Save Visit
        $sql = "INSERT INTO visits (patient_id, doctor_id, symptoms, diagnosis, bp, weight, notes) VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$patient_id, $_SESSION['user_id'], $_POST['symptoms'], $_POST['diagnosis'], $_POST['bp'], $_POST['weight'], $_POST['notes']]);
        $visit_id = $pdo->lastInsertId();

        // 2. Save Prescriptions (Loop through array)
        if (isset($_POST['drug_name'])) {
            $p_sql = "INSERT INTO prescriptions (visit_id, medicine_name, dosage, frequency, duration) VALUES (?, ?, ?, ?, ?)";
            $p_stmt = $pdo->prepare($p_sql);
            
            for ($i = 0; $i < count($_POST['drug_name']); $i++) {
                if(!empty($_POST['drug_name'][$i])){
                    $p_stmt->execute([
                        $visit_id, 
                        $_POST['drug_name'][$i], 
                        $_POST['dosage'][$i], 
                        $_POST['frequency'][$i], 
                        $_POST['duration'][$i]
                    ]);
                }
            }
        }
        
        // 3. Save Lab Requests
        if (isset($_POST['lab_test'])) {
            $l_stmt = $pdo->prepare("INSERT INTO lab_requests (visit_id, test_name) VALUES (?, ?)");
            foreach ($_POST['lab_test'] as $test) {
                if(!empty($test)) $l_stmt->execute([$visit_id, $test]);
            }
        }

        $pdo->commit();
        // Redirect to print page
        header("Location: print_prescription.php?visit_id=" . $visit_id);
        exit;

    } catch (Exception $e) {
        $pdo->rollBack();
        echo "Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <title>Doctor Console</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .history-panel { background: #f8f9fa; border-left: 2px solid #0d6efd; height: 100vh; overflow-y: scroll; }
        .allergy-alert { background: #ffcccc; color: #a00; font-weight: bold; padding: 5px; }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-9 p-4">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h2><?= $p['full_name'] ?> (<?= $p['gender'] ?>)</h2>
                <?php if($p['allergies']): ?>
                    <div class="allergy-alert">⚠️ ALLERGIES: <?= $p['allergies'] ?></div>
                <?php endif; ?>
            </div>

            <form method="POST">
                <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
                
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label>Symptoms / Complaints</label>
                        <textarea name="symptoms" class="form-control" rows="2"></textarea>
                    </div>
                    <div class="col-md-6">
                        <label>Diagnosis</label>
                        <input type="text" name="diagnosis" class="form-control">
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-2"><label>BP</label><input type="text" name="bp" class="form-control"></div>
                    <div class="col-md-2"><label>Weight (kg)</label><input type="number" name="weight" class="form-control"></div>
                </div>

                <h5 class="mt-4">Rx (Prescription)</h5>
                <table class="table table-bordered" id="rxTable">
                    <thead>
                        <tr>
                            <th>Medicine</th>
                            <th>Dosage</th>
                            <th>Freq</th>
                            <th>Duration</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><input type="text" name="drug_name[]" class="form-control" placeholder="Search drug..."></td>
                            <td><input type="text" name="dosage[]" class="form-control" placeholder="500mg"></td>
                            <td>
                                <select name="frequency[]" class="form-select">
                                    <option>bd</option><option>tds</option><option>od</option><option>nocte</option>
                                </select>
                            </td>
                            <td><input type="text" name="duration[]" class="form-control" placeholder="5 days"></td>
                            <td><button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">X</button></td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" class="btn btn-secondary btn-sm mb-3" onclick="addRxRow()">+ Add Medicine</button>

                <h5 class="mt-3">Lab Requests</h5>
                <div id="labList">
                    <div class="input-group mb-2">
                        <input type="text" name="lab_test[]" class="form-control" placeholder="Test Name (e.g. FBC)">
                    </div>
                </div>
                <button type="button" class="btn btn-outline-secondary btn-sm" onclick="addLabRow()">+ Add Lab Test</button>

                <hr>
                <button type="submit" class="btn btn-success btn-lg w-100">Save & Print (A5)</button>
            </form>
        </div>

        <div class="col-md-3 history-panel p-3">
            <h5>Patient History</h5>
            <div class="mb-3">
                <strong>Chronic Conditions:</strong><br>
                <?= $p['chronic_conditions'] ?: 'None' ?>
            </div>
            <hr>
            <h6>Previous Visits</h6>
            <?php
            $hist = $pdo->prepare("SELECT * FROM visits WHERE patient_id = ? ORDER BY visit_date DESC LIMIT 5");
            $hist->execute([$patient_id]);
            while($row = $hist->fetch()):
            ?>
                <div class="card mb-2">
                    <div class="card-body p-2">
                        <small class="text-muted"><?= $row['visit_date'] ?></small><br>
                        <strong>Dx:</strong> <?= $row['diagnosis'] ?>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
    </div>
</div>

<script>
    // JavaScript for dynamic rows
    function addRxRow() {
        var table = document.getElementById("rxTable").getElementsByTagName('tbody')[0];
        var newRow = table.rows[0].cloneNode(true);
        // Clear inputs
        var inputs = newRow.getElementsByTagName('input');
        for(var i=0; i<inputs.length; i++) inputs[i].value = '';
        table.appendChild(newRow);
    }
    function removeRow(btn) {
        var row = btn.parentNode.parentNode;
        if(row.parentNode.rows.length > 1) row.parentNode.removeChild(row);
    }
    function addLabRow() {
        var div = document.createElement('div');
        div.className = 'input-group mb-2';
        div.innerHTML = '<input type="text" name="lab_test[]" class="form-control" placeholder="Test Name">';
        document.getElementById('labList').appendChild(div);
    }
</script>
</body>
</html>