<?php
require '../../includes/auth.php';
// Fetch visit data based on $_GET['visit_id']... (omitted for brevity, assume $visit, $patient, $rx_items are loaded)
?>
<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: 'Segoe UI', sans-serif; font-size: 12pt; }
        .header { text-align: center; border-bottom: 2px solid #000; padding-bottom: 10px; margin-bottom: 20px; }
        .logo { max-height: 60px; }
        .patient-info { display: flex; justify-content: space-between; margin-bottom: 20px; border-bottom: 1px dotted #ccc; }
        .rx-table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        .rx-table th, .rx-table td { text-align: left; padding: 5px; border-bottom: 1px solid #eee; }
        .footer { position: fixed; bottom: 0; width: 100%; font-size: 10pt; text-align: center; border-top: 1px solid #000; padding-top: 10px; }
        .generated-by { position: absolute; bottom: 5px; right: 0; font-size: 8pt; color: #555; }
        
        /* A5 Print Settings */
        @media print {
            @page { size: A5 portrait; margin: 10mm; }
            body { -webkit-print-color-adjust: exact; }
            .no-print { display: none; }
        }
    </style>
</head>
<body onload="window.print()">
    <button class="no-print" onclick="window.history.back()">Back</button>

    <div class="header">
        <img src="../../assets/img/logo.png" class="logo" alt="Jeewaka Hospital">
        <h2>JEEWAKA PRIVATE HOSPITAL</h2>
        <p>123 Main Street, City | Tel: 011-2233445</p>
    </div>

    <div class="patient-info">
        <div>
            <strong>Name:</strong> <?= $patient['full_name'] ?><br>
            <strong>Age/Sex:</strong> <?= $age ?> / <?= $patient['gender'] ?>
        </div>
        <div style="text-align: right;">
            <strong>Date:</strong> <?= date('Y-m-d') ?><br>
            <strong>Visit ID:</strong> #<?= $visit['id'] ?>
        </div>
    </div>

    <div>
        <strong>Diagnosis:</strong> <?= $visit['diagnosis'] ?><br>
        <strong>Vitals:</strong> BP: <?= $visit['bp'] ?> | Wt: <?= $visit['weight'] ?>kg
    </div>

    <h3>Rx</h3>
    <table class="rx-table">
        <thead>
            <tr><th>Medicine</th><th>Dosage</th><th>Freq</th><th>Dur</th></tr>
        </thead>
        <tbody>
            <?php foreach($rx_items as $rx): ?>
            <tr>
                <td><b><?= $rx['medicine_name'] ?></b></td>
                <td><?= $rx['dosage'] ?></td>
                <td><?= $rx['frequency'] ?></td>
                <td><?= $rx['duration'] ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <?php if(!empty($lab_tests)): ?>
    <div style="margin-top: 20px;">
        <strong>Lab Requests:</strong><br>
        <ul>
        <?php foreach($lab_tests as $lab) echo "<li>{$lab['test_name']}</li>"; ?>
        </ul>
    </div>
    <?php endif; ?>

    <div class="footer">
        <div style="float:left;">____________________<br>Doctor Signature</div>
        <div class="generated-by">
            ➤ Report generated by: Dr. <?= $_SESSION['full_name'] ?>
        </div>
    </div>
</body>
</html>