<?php
require '../../includes/auth.php';
checkRole(['Doctor', 'Reception', 'Admin']);

$alert = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_POST['csrf_token'] === $_SESSION['csrf_token']) {
    $nic = sanitize($_POST['nic']);
    $mobile = sanitize($_POST['mobile']);
    $fullname = sanitize($_POST['full_name']);
    $dob = sanitize($_POST['dob']);

    // 1. Duplicate Check
    $stmt = $pdo->prepare("SELECT id FROM patients WHERE nic = ? OR mobile = ? OR (full_name = ? AND dob = ?)");
    $stmt->execute([$nic, $mobile, $fullname, $dob]);
    $existing = $stmt->fetch();

    if ($existing) {
        $alert = "<div class='alert alert-warning'>Duplicate found! <a href='visit.php?patient_id={$existing['id']}'>Open Existing Record (ID: {$existing['id']})</a></div>";
    } else {
        // 2. Insert New
        $sql = "INSERT INTO patients (full_name, dob, nic, mobile, address, allergies, chronic_conditions, created_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$fullname, $dob, $nic, $mobile, $_POST['address'], $_POST['allergies'], $_POST['chronic'], $_SESSION['user_id']]);
        
        // Audit Log
        $new_id = $pdo->lastInsertId();
        $pdo->prepare("INSERT INTO audit_logs (user_id, action_type, table_name, record_id, description) VALUES (?, 'CREATE', 'patients', ?, 'New patient registered')")->execute([$_SESSION['user_id'], $new_id]);
        
        header("Location: visit.php?patient_id=" . $new_id);
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <title>Register Patient - Jeewaka Hospital</title>
</head>
<body class="bg-light">
<div class="container mt-4">
    <h3>New Patient Registration</h3>
    <?= $alert ?>
    <form method="POST" class="card p-4 shadow-sm">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
        <div class="row">
            <div class="col-md-6 mb-3">
                <label>Full Name</label>
                <input type="text" name="full_name" class="form-control" required>
            </div>
            <div class="col-md-3 mb-3">
                <label>NIC</label>
                <input type="text" name="nic" class="form-control">
            </div>
            <div class="col-md-3 mb-3">
                <label>Mobile</label>
                <input type="text" name="mobile" class="form-control" required>
            </div>
            <div class="col-md-3 mb-3">
                <label>Date of Birth</label>
                <input type="date" name="dob" id="dob" class="form-control" required onchange="calcAge()">
            </div>
            <div class="col-md-3 mb-3">
                <label>Age</label>
                <input type="text" id="age" class="form-control" readonly>
            </div>
             <div class="col-md-6 mb-3">
                <label class="text-danger">Allergies</label>
                <input type="text" name="allergies" class="form-control" placeholder="Nil if none">
            </div>
        </div>
        <button type="submit" class="btn btn-primary">Register & Start Visit</button>
    </form>
</div>
<script>
function calcAge() {
    // Simple JS Age Calc logic here
    const dob = new Date(document.getElementById('dob').value);
    const diff_ms = Date.now() - dob.getTime();
    const age_dt = new Date(diff_ms); 
    document.getElementById('age').value = Math.abs(age_dt.getUTCFullYear() - 1970);
}
</script>
</body>
</html>